/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GArc;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.graphics.GRoundRect;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

class ArcRenderer {
    private GObject target;
    private Polygon poly;
    private Rectangle oldBounds;
    private double oldStart;
    private double oldSweep;
    private boolean cacheValid;

    public ArcRenderer(GObject gObject) {
        this.target = gObject;
        this.poly = new Polygon();
        this.cacheValid = false;
    }

    public void draw(Graphics graphics) {
        this.validateCache();
        if (((GFillable)((Object)this.target)).isFilled()) {
            graphics.setColor(((GFillable)((Object)this.target)).getFillColor());
            graphics.fillPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
            graphics.setColor(this.target.getColor());
            graphics.drawPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        } else if (this.target instanceof GOval) {
            graphics.drawPolygon(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        } else {
            graphics.drawPolyline(this.poly.xpoints, this.poly.ypoints, this.poly.npoints - 1);
        }
    }

    private void validateCache() {
        GObject gObject;
        Rectangle rectangle = null;
        double d = 0.0;
        double d2 = 360.0;
        if (this.target instanceof GOval) {
            rectangle = ((GOval)this.target).getAWTBounds();
        } else if (this.target instanceof GRoundRect) {
            gObject = (GRoundRect)this.target;
            rectangle = ((GRect)gObject).getAWTBounds();
        } else {
            gObject = (GArc)this.target;
            rectangle = ((GArc)gObject).getAWTBounds();
            d = ((GArc)gObject).getStartAngle();
            d2 = ((GArc)gObject).getSweepAngle();
            if (d != this.oldStart || d2 != this.oldSweep) {
                this.cacheValid = false;
            }
        }
        if (rectangle == null || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        if (!this.cacheValid || rectangle.width != this.oldBounds.width || rectangle.height != this.oldBounds.height) {
            this.poly.npoints = 0;
            if (this.target instanceof GRoundRect) {
                gObject = (GRoundRect)this.target;
                int n = GMath.round(((GRoundRect)gObject).getArcWidth());
                int n2 = GMath.round(((GRoundRect)gObject).getArcHeight());
                this.poly.addPoint(rectangle.x + n / 2, rectangle.y);
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, n, n2);
                this.addArc(rectangle2, 90.0, 90.0);
                rectangle2.y = rectangle.y + rectangle.height - n2;
                this.addArc(rectangle2, 180.0, 90.0);
                rectangle2.x = rectangle.x + rectangle.width - n;
                this.addArc(rectangle2, 270.0, 90.0);
                rectangle2.y = rectangle.y;
                this.addArc(rectangle2, 0.0, 90.0);
            } else {
                this.addArc(rectangle, d, d2);
                if (this.target instanceof GArc) {
                    this.poly.addPoint(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
                    this.oldStart = d;
                    this.oldSweep = d2;
                }
            }
            this.oldBounds = rectangle;
        }
        if (rectangle.x != this.oldBounds.x || rectangle.y != this.oldBounds.y) {
            this.poly.translate(rectangle.x - this.oldBounds.x, rectangle.y - this.oldBounds.y);
            this.oldBounds = rectangle;
        }
        this.cacheValid = true;
    }

    private void addArc(Rectangle rectangle, double d, double d2) {
        double d3 = (double)rectangle.height / (double)rectangle.width;
        double d4 = (double)rectangle.width / 2.0;
        double d5 = (double)rectangle.height / 2.0;
        double d6 = (double)rectangle.x + d4;
        double d7 = (double)rectangle.y + d5;
        if (d2 < 0.0) {
            d += d2;
            d2 = -d2;
        }
        if (d2 > 359.99) {
            d2 = 360.0;
        }
        double d8 = Math.atan2(1.0, Math.max(rectangle.width, rectangle.height));
        int n = (int)(GMath.toRadians(d2) / d8);
        d8 = GMath.toRadians(d2) / (double)n;
        double d9 = GMath.toRadians(d);
        int n2 = 0;
        while (n2 <= n) {
            double d10 = d6 + d4 * Math.cos(d9);
            double d11 = d7 - d4 * Math.sin(d9) * d3;
            this.poly.addPoint(GMath.round(d10), GMath.round(d11));
            d9 += d8;
            ++n2;
        }
    }
}

